var max_levels = 16;

var level_names = new Array()

level_names[0] = "TRAINING";
level_names[1] = "ENTRANCE";
level_names[2] = "HANGARS";
level_names[3] = "STORAGE";
level_names[4] = "CONTROL ROOM";
level_names[5] = "STORAGE 2";
level_names[6] = "HANGERS 2";
level_names[7] = "SHAFTS";
level_names[8] = "LABORATORY";
level_names[9] = "ID";
level_names[10] = "LOWER SHAFTS";
level_names[11] = "???";
level_names[12] = "AMMO STORAGE";
level_names[13] = "SUPERNAUT";
level_names[14] = "KATABASIS";
level_names[15] = "RUN";
level_names[16] = "THE TOWER";
level_names[17] = "THE THRONE";

var bg11 = LoadImage("background11.png")
var bg15 = LoadImage("background15.png")
var bg18 = LoadImage("background18.png")
var bg_x1 = 0;
var bg_y1 = 0;
var bg15_x1 = 0;
var bg15_y1 = 0;
var bg18_x1 = 0;
var bg18_y1 = 0;


var fonty = LoadFont("fonty.rfn");
fonty.setColorMask(CreateColor(160,35,24, 255));

function DrawBackGroundImage()
{
	if (g_current_level == 11)
		bg11.blit(bg_x1, bg_y1);
	else if (g_current_level == 13)
		bg11.blit(bg_x1, bg_y1);
	else if (g_current_level == 14)
		bg11.blit(bg_x1, bg_y1);
	else if (g_current_level == 15)
		bg15.blit(bg15_x1, 0);
	else if (g_current_level == 16)
		bg15.blit(bg15_x1, bg15_y1);
	else if (g_current_level == 18)
		bg18.blit(bg18_x1, bg18_y1);

}


function SaveLevelChangeInfo(levely)
{
	if (levely>= max_levels)
	  Abort("max_levels is not set high enough");
  if (levely == undefined)
  {
		//clear all game save info
		for (i=0;i<max_levels;i++)
		{
			file = OpenFile("autoslot_level"+i+".sav");
			file.write("cleared", 1);
			file.flush();
			file.close();
		}
  }
  else
  {
		//just save the current level's information

		file = OpenFile("autoslot_level"+levely+".sav");
		file.write("cleared", 0);
		
		//write info:
		//zones triggered
		for (i=0;i<max_map_zones;i++)
		{
			file.write("mapzones"+i, map_zones[i]);
		}			
			
		//doors
			//lockers
			//switches
		for (i=0;i<max_doors;i++)
		{
			file.write("doors"+i+"x", doors[i].x);
			file.write("doors"+i+"y", doors[i].y);
			file.write("doors"+i+"layer", doors[i].layer);
			file.write("doors"+i+"dir", doors[i].dir);
			file.write("doors"+i+"frame", doors[i].frame);
			file.write("doors"+i+"type", doors[i].type);
			file.write("doors"+i+"hp", doors[i].hp);
				//type 1-regular door
				//type 2-switch
				//type 3-switch door
				//type 4-hp door
		
			file.write("doors"+i+"active", doors[i].active);
		
			file.write("doors"+i+"target", doors[i].target);
			file.write("doors"+i+"name", doors[i].name);
			//file.write("doors"+i+"id1", doors[i].id1);	
		}

		//guts
		file.write("maxguts", max_guts);
		file.write("minguts", min_guts);
		
		for (i=0;i<max_guts;i++)
		{
			file.write("guts"+i+"x", guts[i].x);
			file.write("guts"+i+"y", guts[i].y);
		
			file.write("guts"+i+"vx", guts[i].vx);
			file.write("guts"+i+"vy", guts[i].vy);
			file.write("guts"+i+"name", guts[i].name);
		
			file.write("guts"+i+"frame", guts[i].frame);
			file.write("guts"+i+"direction", guts[i].direction);
			file.write("guts"+i+"flamed", guts[i].flamed);
			file.write("guts"+i+"blood", guts[i].blood);
			file.write("guts"+i+"layer", guts[i].layer);
			//file.write("guts"+i+"id1", guts[i].id1);
		}

		//heads
		for (i=0;i<max_heads;i++)
		{
			file.write("heads"+i+"x", heads[i].x);
			file.write("heads"+i+"y", heads[i].y);
		
			file.write("heads"+i+"vx", heads[i].vx);
			file.write("heads"+i+"vy", heads[i].vy);
			file.write("heads"+i+"name", heads[i].name);
		
			file.write("heads"+i+"id1", heads[i].id1);
			file.write("heads"+i+"frame", heads[i].frame);
			file.write("heads"+i+"direction", heads[i].direction);
			file.write("heads"+i+"flamed", heads[i].flamed);
			file.write("heads"+i+"active", heads[i].active);
			file.write("heads"+i+"stop", heads[i].stop);
			file.write("heads"+i+"rotation", heads[i].rotation);
		}

		//entities
		for (i=1;i<max_entities;i++)
		{
			file.write("entities"+i+"x", entities[i].x );
			file.write("entities"+i+"y", entities[i].y);
			file.write("entities"+i+"vx", entities[i].vx);
			file.write("entities"+i+"vy", entities[i].vy);
			file.write("entities"+i+"layer", entities[i].layer);
			file.write("entities"+i+"dir", entities[i].dir);
			file.write("entities"+i+"dir1", entities[i].dir1);
			file.write("entities"+i+"dir2", entities[i].dir2);
			file.write("entities"+i+"frame1", entities[i].frame1);
			file.write("entities"+i+"frame2", entities[i].frame2);
			file.write("entities"+i+"mask", entities[i].mask);
			
			file.write("entities"+i+"hp", entities[i].hp);
			file.write("entities"+i+"hp1", entities[i].hp1);//arm1
			file.write("entities"+i+"hp2", entities[i].hp2);//arm2
			file.write("entities"+i+"hp3", entities[i].hp3);//legs
			file.write("entities"+i+"maxhp", entities[i].maxhp);
			file.write("entities"+i+"name", entities[i].name);
			file.write("entities"+i+"spriteset", entities[i].spriteset);
			file.write("entities"+i+"type", entities[i].type);
			file.write("entities"+i+"farm", entities[i].farm);
			file.write("entities"+i+"invince", entities[i].invince);
			file.write("entities"+i+"active", entities[i].active);
			file.write("entities"+i+"ambush", entities[i].ambush);
			file.write("entities"+i+"w", entities[i].w);
			file.write("entities"+i+"h", entities[i].h);
			//file.write("entities"+i+"id1", entities[i].id1);
			//file.write("entities"+i+"id2", entities[i].id2);
			//file.write("entities"+i+"id3", entities[i].id3);
		}
		
		//blood.
		
		var mapyengy = GetMapEngine()
		mapyengy.save("auto"+levely+".rmp");
  }
}

function LoadLevelChangeInfo(levely)
{
	//stuff
	
	file = OpenFile("autoslot_level"+levely+".sav");
	if (file.read("cleared", 1) == 1)
	{
	  return;
	}
	else
	{
	}
	file.close();
}

var levelnames = new Array();

levelnames[0] = "Training";
levelnames[1] = "Entrance";
levelnames[2] = "Hangars";
levelnames[3] = "Storage";
levelnames[4] = "Ground Control Centre";
levelnames[5] = "Storage 2";
levelnames[6] = "Hangars 2";
levelnames[7] = "Shafts";
levelnames[8] = "Laboratory";
levelnames[9] = "Id";
levelnames[10] = "Lower Shafts";
levelnames[11] = "???";
levelnames[12] = "Ammo Storage";
levelnames[13] = "Supernaut";
levelnames[14] = "Katabasis";
levelnames[15] = "Run";
levelnames[16] = "The Tower";
levelnames[17] = "The Throne";


var ldis = new Array();

for (i=0;i<19;i++)
{
	ldis[i] = i;
	if (i > 6)
		ldis[i] = i-2;
}


function ShowEndingScreen()
{
	PauseAllMusic();
	ClearPauseMusicStats();
	
	SaveWeapPossess();
	g_stage_load = -1;

	//SupernautEndScene();
	if (g_exit_level == 14)
	{
		//do ending cutscene here
		
		
		//...
		if (SupernautEndScene() == true)
		{
			ShowCredits();
			RestartGame();
			return;
		}
		else
		{
			//keep going!
			SupernautEndScene2();
		}
	}
	
	if (g_exit_level == 2)
	{
		var bg = LoadImage("level_end1.png");
	}
	else if (g_exit_level == 3)
	{
		var bg = LoadImage("level_end2.png");
	}
	else if (g_exit_level == 4)
	{
		var bg = LoadImage("level_end3.png");
	}
	else if (g_exit_level == 5)
	{
		var bg = LoadImage("level_end4.png");
	}
	else if (g_exit_level == 6)
	{
		var bg = LoadImage("level_end5.png");
	}
	else if (g_exit_level == 7)
	{
		var bg = LoadImage("level_end6.png");
	}
	else if (g_exit_level == 8)
	{
		var bg = LoadImage("level_end7.png");
	}
	else if (g_exit_level == 9)
	{
		var bg = LoadImage("level_end8.png");
	}
	else if (g_exit_level == 10)
	{
		var bg = LoadImage("level_end9.png");
	}
	else if (g_exit_level == 11)
	{
		var bg = LoadImage("level_end10.png");
	}
	else if (g_exit_level == 12)
	{
		var bg = LoadImage("level_end11.png");
	}
	else if (g_exit_level == 13)
	{
		var bg = LoadImage("level_end12.png");
	}
	else if (g_exit_level == 14)
	{
		var bg = LoadImage("level_end13.png");
	}
	else if (g_exit_level == 15)
	{
		var bg = LoadImage("level_end14.png");
	}
	else if (g_exit_level == 16)
	{
		var bg = LoadImage("level_end15.png");
	}
	else if (g_exit_level == 17)
	{
		var bg = LoadImage("level_end16.png");
	}
	
	
	var button1 = LoadImage("level_end_button1.png");
	var mousepic = LoadImage("dot2.png");
	
//calculate time:
	var tseconds=Math.floor(g_total_time+g_frames*25/750);
	var mins=Math.floor(tseconds/60)%60;
	var hours=Math.floor(tseconds/3600);
	var secs=tseconds%60;
	
	if (hours > 9)
	{
		hours = 9;
		mins = 59;
		secs = 59;
	}
	
	var string = hours+":";
	

	if (mins<10)
	  string+= "0"+mins+":";
	else
	  string+= ""+mins+":";

	if (secs<10)
		string += "0"+secs;
	else
		string += ""+secs;
	
	
	var stringy1 = "Level "+(ldis[g_exit_level-1])+": '"+levelnames[g_exit_level-1]+"' Complete";

	var MClick = false;
	var maxfade = 20;
	
	var fadecount = 0;
	
	var lasttime = GetTime();

	g_total_time=tseconds;//
	g_total_kills+=g_kills;


	while(fadecount < 40)
	{
		bg.blit(0,120-bg.height/2);
	
		font.drawText(160-font.getStringWidth(stringy1)/2,8, stringy1);
		font.drawText(8,224, "Total Time: " + string);
		font.drawText(132,224, "Total Kills: " + g_total_kills);
	
		button1.blit(250, 216);
		mousepic.blit(GetMouseX(), GetMouseY());
		if (fadecount < 20)
			Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(0,0,0,255-fadecount*255/maxfade));
		else if (fadecount > 20)
			Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(0,0,0,(fadecount-20)*255/maxfade));
		FlipScreen();
		
		while(GetTime()-lasttime < 33);
		lasttime = GetTime();

		if (fadecount < 20)
			fadecount+=2;
		else if (fadecount > 20)
			fadecount+=2;

		if (!IsMouseButtonPressed(MOUSE_LEFT))
			MClick = false;
		else if (fadecount <= 20)
		{
			MClick = true;
			if (GetMouseX()> 250 && GetMouseX()<300 && GetMouseY()>216 && GetMouseY()<216+16)
			{
				fadecount = 21;
				sounds[4].stop();
				sounds[4].setPosition(0);
				sounds[4].play(false);
				break;
			}
		}
	}
//	FlipScreen();
	//buttons for continue here.
	//screen for map and saving here.
	if (g_exit_level == 5)
		g_exit_level+=2;
	//autosave
	SaveToSlot(4,"autosave");

	MapScreeny();
}

function MapScreeny()
{
	if (g_exit_level >= 2 && g_exit_level < 10)
	{
		var bg = LoadImage("map0"+g_exit_level+".png");
	}
	else if (g_exit_level >= 10)
	{
		var bg = LoadImage("map"+g_exit_level+".png");
	}
	else 
		var bg = LoadImage("map00.png");

	var bg2 = LoadImage("map00.png");
		
	var button1 = LoadImage("level_end_save1.png");
	var button2 = LoadImage("level_end_go1.png");
	var mousepic = LoadImage("dot2.png");
	var sloty = LoadImage("level_end_slot1.png");

	var MClick = true;
	var maxfade = 20;
	var fadecount = 0;
	var lasttime = GetTime();
	var frameys = 0;
	var savemenu = false;
	var message = "";
	var select_slot = -1;
	
	var slotnames = new Array(4);
	
	slotnames[0] = new Array(11);
	slotnames[1] = new Array(11);
	slotnames[2] = new Array(11);
	slotnames[3] = new Array(11);

	function SetSlotName(slot, string)
	{
		for (sj2=0;sj2<11;sj2++)
		{
			slotnames[slot][sj2] = "";
			if (sj2<string.length)
			{
				slotnames[slot][sj2] = string.charAt(sj2);
			}
		}
	}
	function GetSlotName(slot)
	{
		var stringy = "";
		for (sj1=0;sj1<11;sj1++)
		{
			stringy+=slotnames[slot][sj1];
		}
		return stringy;
	}
	
//	while(AreKeysLeft())
//	GetKey();
	var filey;

	for (sj1=0;sj1<4;sj1++)
	{
		filey = OpenFile("slot"+sj1+".rtd");
		SetSlotName(sj1,filey.read("name", "empty"));
	}
	
	filey.close();

//	font.drawText(0,0, slotnames[0][0]);
//	FlipScreen();
//	GetKey();

	var key = 0;

	var c_position=0;
	var pre_name = "";
	var t_stringy = "";
	var message_count = 0;
	

	while(fadecount < 20)
	{
		frameys++;
		if (Math.floor(frameys/4) % 2 == 0)
			bg.blit(0,20);//120-bg.height/2);
		else
			bg2.blit(0,20);//120-bg.height/2);
		fonty.drawText(15,15, "LEVEL "+ldis[g_exit_level]+":")
		fonty.drawText(305-fonty.getStringWidth(level_names[g_exit_level]), 30, level_names[g_exit_level]);

		
		if (savemenu == true)
		{
			if (select_slot >= 0)
			{
				Rectangle(3, 216-82+select_slot*20, sloty.width+4, sloty.height+4, CreateColor(32,160,64,255))
			}

			sloty.blit(5, 216-80);
				font.drawText(8,218-80, GetSlotName(0));
			sloty.blit(5, 216-60);
				font.drawText(8,218-60, GetSlotName(1));
			sloty.blit(5, 216-40);
				font.drawText(8,218-40, GetSlotName(2));
			sloty.blit(5, 216-20);
				font.drawText(8,218-20, GetSlotName(3));
			if (select_slot >= 0 && Math.floor(frameys/4) % 2 == 0)
			{
				var t_stringy = GetSlotName(select_slot);
				font.drawText(8+font.getStringWidth(t_stringy.substr(0,c_position)),218-80+20*select_slot, "_");
			}
			

		}
		
		if (message_count > 0)
		{
			message_count--;
			font.drawText(160-font.getStringWidth(message)/2, 224, message);
		}

		button1.blit(20, 216);
		button2.blit(250, 216);
		mousepic.blit(GetMouseX(), GetMouseY());

		if (fadecount <= 20 && fadecount > 0)
			Rectangle(0,0,GetScreenWidth(), GetScreenHeight(), CreateColor(0,0,0,fadecount*255/maxfade));

		FlipScreen();
		
		while(GetTime()-lasttime < 33);
			lasttime = GetTime();

		if (fadecount < 20 && fadecount > 0)
			fadecount+=2;

		if (!IsMouseButtonPressed(MOUSE_LEFT))
			MClick = false;
		else if (fadecount < 1 && MClick == false)
		{
			MClick = true;
			if (GetMouseX()> 250 && GetMouseX()<300 && GetMouseY()>216 && GetMouseY()<216+16)
			{
				fadecount = 1;
				sounds[6].stop();
				sounds[6].setPosition(0);
				sounds[6].play(false);
			}
			else if (GetMouseX()> 20 && GetMouseX()<70 && GetMouseY()>216 && GetMouseY()<216+16)
			{
				if (savemenu == false)
				{
					savemenu = true;
				}
				else
				{
					savemenu = false;
				}

				sounds[6].stop();
				sounds[6].setPosition(0);
				sounds[6].play(false);
			}
			else if (savemenu==true)
			{
				for (si=0;si<4;si++)
				{
					if (GetMouseX()> 5 && GetMouseX()<95 && GetMouseY()>216-20*(si+1) && GetMouseY()<216+16-20*(si+1))
					{
						//slot 4-si save
						select_slot = 3-si;
						
						pre_name = GetSlotName(3-si);
						c_position=0;
						
						while(AreKeysLeft())
							GetKey();
						
						sounds[6].stop();
						sounds[6].setPosition(0);
						sounds[6].play(false);
						break;
					}
				}
			}
		}
		
		if (select_slot > -1)
		{
			while(AreKeysLeft() && select_slot > -1)
			{
				key = GetKey();
				if (inputs2[key] != undefined)
				{
					if (IsKeyPressed(KEY_SHIFT))
						slotnames[select_slot][c_position]=inputs2[key];
					else
						slotnames[select_slot][c_position]=(inputs2[key]).toLowerCase();

					if (c_position<10)
						c_position++;
				}
				else if (key == KEY_LEFT)
				{
					if (c_position > 0)
						c_position--;
				}
				else if (key == KEY_RIGHT)
				{
					if (c_position < 10)
						c_position++;
				}
				else if (key == KEY_BACKSPACE)
				{
					if (c_position > 0)
					{
						for (sj=c_position-1; sj < 10;sj++)
						{
							slotnames[select_slot][sj] = slotnames[select_slot][sj+1]
						}
						slotnames[select_slot][10] = " ";
						c_position--;
					}
				}
				else if (key == KEY_DELETE)
				{
					slotnames[select_slot][c_position] = " ";

					for (sj=c_position; sj < 10;sj++)
					{
						slotnames[select_slot][sj] = slotnames[select_slot][sj+1]
					}

					slotnames[select_slot][10] = " ";
				}
				else if (key == KEY_ENTER)
				{
					//save slot here.
					message = "Game Saved!";
					SaveToSlot(select_slot, GetSlotName(select_slot));
					message_count = 30;
					select_slot = -1;
				}
				else if (key == KEY_ESCAPE)
				{
					SetSlotName(select_slot, pre_name);
					select_slot = -1;
				}
			}
		}
	}
	FlipScreen();
}

var g_stage_load = -1;

function AutoSpecialSave(stage)
{
	SaveToSlot(-1,"autosave",stage);
}

function SaveToSlot(number,name,stage)
{
	if (number != -1)
	{
		if (g_exit_level == 18)
			return;
	}
	else
	{
		if (g_current_level == 18)
			return;
	}
		
	
	var stfile = OpenFile("../game.sgm");
	stfile.write("asf", number);
	stfile.close();
	



	g_reset_load = number;
	var file = OpenFile("slot"+number+".rtd");
	file.write("name", name);
	if (number != -1)
		file.write("level", g_exit_level);
	else
		file.write("level", g_current_level);
	
	file.write("kills", g_total_kills);
	file.write("totaltime", g_total_time);
	file.write("score", gore_score);

	//armour, ammo
	//adren.
	
	for (sts = 0; sts < max_ammos;sts++)
	{
		file.write("ammo"+sts, ammo_array[sts].curammo);
		file.write("clip"+sts, ammo_array[sts].curclip);
	}
	
	for (sts=0;sts<16;sts++)
	{ 
		file.write("weap"+sts, weap_possess[sts]);
	}

	var date  = new Date;
	
	file.write("d_minutes", date.getUTCMinutes());
	file.write("d_hours", date.getUTCHours());
	file.write("d_day", date.getUTCDate());
	file.write("d_month", date.getUTCMonth());
	file.write("d_year", date.getUTCFullYear());

	file.write("diff", g_diff);
	file.write("cur_weap", cur_weap);
	
	if (stage > -1)
		file.write("stage", stage);
	else
		file.write("stage", -1);
	
	file.flush();
	file.close();
}


function LoadSlot(number)
{
	var stfile = OpenFile("../game.sgm");
	var st = stfile.read("asf", 0);

	g_stage_load = -1;


	if (number == -1)
		number = st;
	else
	{/*
		while(AreKeysLeft())GetKey();
		font.drawText(0,0,number);
		FlipScreen();
		GetKey();*/
		stfile.write("asf", number);
		stfile.flush();
	}
	stfile.close();

	g_reset_load = number;
	var file = OpenFile("slot"+number+".rtd");
	g_exit_level = file.read("level", 1);
	g_current_level = g_exit_level;
	
	

	if (g_current_level != -1)
	{
		g_total_kills = file.read("kills", 0);
		g_total_time = file.read("totaltime", 0);
		gore_score = file.read("score", 0);
		
		
		//armour, ammo
		//adren.
		
		for (sts = 0; sts < max_ammos;sts++)
		{
			ammo_array[sts].curammo=file.read("ammo"+sts, ammo_array[sts].curammo);
			ammo_array[sts].curclip=file.read("clip"+sts, ammo_array[sts].curclip);
		}
		
		for (sts=0;sts<16;sts++)
		{ 
			weap_possess[sts]=file.read("weap"+sts, weap_possess[sts]);
		}
	
		g_stage_load = file.read("stage", -1);
		g_diff = file.read("diff", g_diff);
		cur_weap = file.read("cur_weap", cur_weap);
		g_chosen_diff = g_diff;

	}
	else
	{


		g_exit_level = 1;
		g_current_level = 1;
	
		g_kills = 0;
		g_total_time = 0;
		gore_score = 0;
	
		//armour, ammo
		//adren.
		
		for (sts = 0; sts < max_ammos;sts++)
		{
			ammo_array[sts].curammo=0;
			ammo_array[sts].curclip=0;
		}
		
		for (sts=0;sts<16;sts++)
		{ 
			weap_possess[sts]=0;
		}

		weap_possess[0] = 1;
		ammo_array[0].curclip = 12;
		ammo_array[0].curammo = 120;
		ammo_array[1].curclip = 1;
		ammo_array[1].curammo = 6;
	
		g_diff = 0;
		cur_weap = 1;
		g_chosen_diff = 0;
	
	}
}




















